/*
 * Decompiled with CFR 0.152.
 */
import bird.comm.CommExc;
import bird.gui.IPAddrEditPanel;
import bird.util.Dbg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BPMEUpd
extends JFrame
implements ActionListener,
WindowListener {
    private macTextField[] macAddr;
    private Panel macAddrPanel;
    EncryptedTCPIPCommInt encTcp = null;
    private udpip gtp_ = null;
    private int port_ = 0;
    private byte cmd_ = 0;
    private byte[] cmdStr_;
    private byte[] resp_ = new byte[512];
    private IPAddrEditPanel ipSubnetMask_;
    private JButton btnSetupDefault_;
    private JButton btnLaunchWebPg_;
    private JLabel lblFileNameWeb_;
    private JLabel lblCRCWeb_;
    private JLabel lblFileNameFirmware_;
    private JLabel lblCRCFirmware_;
    private WorkerThread workerTh_ = new WorkerThread(1);
    private boolean isExecuting_ = false;
    private boolean isOperationCanceled_ = false;
    private Cursor oldCursor_ = null;
    private static final Color COLOR_BG = new Color(0, 102, 255);
    private static final Color COLOR_FG = Color.black;
    private static final String TXT_UNKNOWN_FILE_NAME = "---- UNKNOWN FILE ----";

    public BPMEUpd(String string) {
        super(string);
        this.workerTh_.start();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createFilesPanel(), "North");
        this.getContentPane().add((Component)this.createNetworkPanel(), "Center");
        this.getContentPane().add((Component)Status.getInst().createGUI(), "South");
        Status.getInst().addKeyListener(new StatusKeyAdapter());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.btnLaunchWebPg_.getActionCommand().equals(string)) {
            this.handle_launchWebPage();
        } else if (this.btnSetupDefault_.getActionCommand().equals(string)) {
            this.handle_setDefaultSettings();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        boolean bl = true;
        if (this.isExecuting_) {
            try {
                int n = JOptionPane.showConfirmDialog(this, "This will cancel the current operation!\nDo you wish to continue?", "BPME Updater", 0, 2);
                if (n != 0) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.setOperationCanceled(true);
            this.workerTh_.setMustStop(true);
            this.workerTh_.wakeup();
            this.closeUDP();
            try {
                this.workerTh_.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispose();
            System.exit(0);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void computeCRCValues() {
        this.setWaitCursor();
        this.workerTh_.addCmd(new GUIWorkerCmd(){

            public void execute() {
                BPMEUpd.this.computeCRCs();
            }

            public void onFinished() {
                BPMEUpd.this.restoreCursor();
            }
        });
    }

    private void computeCRCs() {
        Status.getInst().log("Computing CRC values...");
        String string = SetupProperties.getInst().getProperty("firmware");
        File file = new File(string);
        if (string.length() > 0) {
            this.lblFileNameFirmware_.setText(file.getName());
            this.lblCRCFirmware_.setText(BPMEUpd.formatCRC16(this.computeCRC(file)));
        } else {
            this.lblFileNameFirmware_.setText(TXT_UNKNOWN_FILE_NAME);
            this.lblCRCFirmware_.setText(BPMEUpd.formatCRC16(0));
        }
        string = SetupProperties.getInst().getProperty("webIn");
        file = new File(string);
        if (string.length() > 0) {
            this.lblFileNameWeb_.setText(file.getName());
            this.lblCRCWeb_.setText(BPMEUpd.formatCRC16(this.computeCRC(file)));
        } else {
            this.lblFileNameWeb_.setText(TXT_UNKNOWN_FILE_NAME);
            this.lblCRCWeb_.setText(BPMEUpd.formatCRC16(0));
        }
        Status.getInst().append("OK.\n");
    }

    private JPanel createFilesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Font font = new Font(null, 1, 14);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel("Firmware:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.lblFileNameFirmware_ = new JLabel(TXT_UNKNOWN_FILE_NAME);
        this.lblFileNameFirmware_.setForeground(COLOR_FG);
        this.lblFileNameFirmware_.setFont(font);
        jPanel.add((Component)this.lblFileNameFirmware_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel("CRC:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.lblCRCFirmware_ = new JLabel(BPMEUpd.formatCRC16(0));
        this.lblCRCFirmware_.setForeground(COLOR_FG);
        this.lblCRCFirmware_.setFont(font);
        jPanel.add((Component)this.lblCRCFirmware_, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jLabel = new JLabel("Web:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.lblFileNameWeb_ = new JLabel(TXT_UNKNOWN_FILE_NAME);
        this.lblFileNameWeb_.setForeground(COLOR_FG);
        this.lblFileNameWeb_.setFont(font);
        jPanel.add((Component)this.lblFileNameWeb_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel("CRC:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.lblCRCWeb_ = new JLabel(BPMEUpd.formatCRC16(0));
        this.lblCRCWeb_.setForeground(COLOR_FG);
        this.lblCRCWeb_.setFont(font);
        jPanel.add((Component)this.lblCRCWeb_, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        return jPanel;
    }

    private JPanel createNetworkPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.createFindBPMEPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.createCtrlPanel(), gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        return jPanel;
    }

    private JPanel createFindBPMEPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Enter Mac Address for device:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.macAddrPanel = new Panel(new GridLayout(1, 6, 0, 0));
        this.macAddr = new macTextField[6];
        for (int i = 0; i < 6; ++i) {
            this.macAddr[i] = new macTextField("FF", 2);
            this.macAddrPanel.add(this.macAddr[i]);
        }
        jPanel.add((Component)this.macAddrPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 0;
        this.btnSetupDefault_ = new JButton("Update Firmware");
        this.btnSetupDefault_.addActionListener(this);
        this.btnSetupDefault_.setActionCommand("btnSetupDefault_Click");
        jPanel.add((Component)this.btnSetupDefault_, gridBagConstraints);
        return jPanel;
    }

    private JPanel createCtrlPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(25, 10, 2, 2);
        gridBagConstraints.anchor = 10;
        this.btnLaunchWebPg_ = new JButton("Launch Unit Webpage");
        this.btnLaunchWebPg_.addActionListener(this);
        this.btnLaunchWebPg_.setActionCommand("btnLaunchWebPg_Click");
        this.btnLaunchWebPg_.setEnabled(false);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.btnLaunchWebPg_, gridBagConstraints);
        return jPanel;
    }

    private synchronized void setWaitCursor() {
        if (this.oldCursor_ == null) {
            this.oldCursor_ = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private synchronized void restoreCursor() {
        if (this.oldCursor_ != null) {
            this.setCursor(this.oldCursor_);
        }
        this.oldCursor_ = null;
    }

    private boolean uploadWebandFirmware(InetAddress inetAddress) {
        try {
            SetupProperties.getInst().load();
        }
        catch (Exception exception) {
            Status.getInst().log("Unable to load properties file!\n");
            return false;
        }
        if (SetupProperties.getInst().getProperty("isFirmwareEnabled").toLowerCase().equals("true")) {
            String string = SetupProperties.getInst().getProperty("firmware");
            if (!this.uploadToXPORT(string, "X5", inetAddress)) {
                if (SetupProperties.getInst().getProperty("isIntFirmwareEn").toLowerCase().equals("true")) {
                    Status.getInst().log("Trying different Version\n");
                    String string2 = SetupProperties.getInst().getProperty("intFirmware");
                    if (!this.uploadToXPORT(string2, "X2", inetAddress)) {
                        Status.getInst().log("Intermediate Firmware load failed\n");
                        return false;
                    }
                    Status.getInst().log("Intermediate Firmware loaded\n");
                    Status.getInst().log("Xport is rebooting (~30 secs)...");
                    this.goToSleep(30000);
                    Status.getInst().append("OK.\n");
                    if (!this.uploadToXPORT(string, "X5", inetAddress)) {
                        Status.getInst().log("New Firmware load failed\n");
                        return false;
                    }
                } else {
                    return false;
                }
            }
            Status.getInst().log("Xport is rebooting (~30 sec)...");
            this.goToSleep(30000);
            Status.getInst().append("OK.\n");
        }
        if (SetupProperties.getInst().getProperty("isWebContentEnabled").toLowerCase().equals("true") && !this.uploadWebContent(inetAddress)) {
            Status.getInst().log("New Web load failed\n");
            return false;
        }
        Status.getInst().log("Web and firmware loaded\n");
        return true;
    }

    private void launchWebPage() {
        Object object;
        Object object2;
        InetAddress inetAddress;
        boolean bl = true;
        try {
            inetAddress = InetAddress.getLocalHost();
            object2 = inetAddress.getAddress();
            object2[3] = (byte)(object2[3] + 1);
            inetAddress = InetAddress.getByAddress((byte[])object2);
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        object2 = inetAddress.getHostAddress();
        String[] stringArray = new String[]{"iexplore", "http://" + (String)object2};
        Runtime runtime = Runtime.getRuntime();
        try {
            object = runtime.exec(stringArray);
            Status.getInst().log("Opening Internet Explorer...\n");
        }
        catch (Exception exception) {
            try {
                stringArray[0] = "netscp";
                Process process = runtime.exec(stringArray);
                Status.getInst().log("Opening Netscape Navigator...\n");
            }
            catch (Exception exception2) {
                try {
                    stringArray[0] = "firefox";
                    Process process = runtime.exec(stringArray);
                    Status.getInst().log("Opening Mozilla Firefox...\n");
                }
                catch (Exception exception3) {
                    bl = false;
                }
            }
        }
        this.goToSleep(1000);
        if (!bl) {
            object = "";
            object = ((String)object2).length() > 0 ? "Enter the following URL in the address bar of your web browser:\nhttp://" + (String)object2 : "Enter the IP address of the desired BPME in the address bar of your web browser.";
            try {
                JOptionPane.showMessageDialog(this, "Unable to find a web browser in your system path.\n" + (String)object, "BPME Updater", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Status.getInst().log("Error opening browser\n");
        }
    }

    private void handle_launchWebPage() {
        this.workerTh_.addCmd(new WorkerCmd(){

            public void execute() {
                BPMEUpd.this.launchWebPage();
            }

            public void finished() {
            }
        });
    }

    private int sendSysCmd(String[] stringArray) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            process.waitFor();
        }
        catch (Exception exception) {
            System.out.println("Error" + stringArray[0] + stringArray[1]);
            return 0;
        }
        return 1;
    }

    private void setDefaultSettings() {
        InetAddress inetAddress;
        Object object;
        InetAddress inetAddress2;
        this.btnLaunchWebPg_.setEnabled(false);
        try {
            inetAddress2 = InetAddress.getLocalHost();
            object = inetAddress2.getAddress();
            object[3] = (byte)(object[3] + 1);
            inetAddress = InetAddress.getByAddress(object);
        }
        catch (UnknownHostException unknownHostException) {
            Status.getInst().log("Unable to get IP address");
            return;
        }
        object = this.macAddr[0].getText() + "-" + this.macAddr[1].getText() + "-" + this.macAddr[2].getText() + "-" + this.macAddr[3].getText() + "-" + this.macAddr[4].getText() + "-" + this.macAddr[5].getText();
        String[] stringArray = new String[]{"arp", "-s", inetAddress.getHostAddress(), object, inetAddress2.getHostAddress()};
        Status.getInst().log("Setting IP address to: " + inetAddress.toString() + "...\n");
        this.sendSysCmd(stringArray);
        this.encTcp = new EncryptedTCPIPCommInt(inetAddress, 1, 1024);
        try {
            this.encTcp.open();
        }
        catch (CommExc commExc) {
            // empty catch block
        }
        this.encTcp.close();
        this.encTcp = new EncryptedTCPIPCommInt(inetAddress, 9999, 1024);
        try {
            this.encTcp.open();
        }
        catch (CommExc commExc) {
            // empty catch block
        }
        this.encTcp.close();
        String[] stringArray2 = new String[]{"arp", "-d", inetAddress.getHostAddress()};
        this.sendSysCmd(stringArray2);
        String[] stringArray3 = new String[]{"ping", inetAddress.getHostAddress()};
        this.unlockXport(inetAddress);
        if (!this.setIPAddressInSetupRecord(inetAddress)) {
            Status.getInst().log("IP address not changed\n");
            return;
        }
        Status.getInst().log("IP address successfully changed\n");
        Status.getInst().log("Xport is rebooting (~20 secs)...");
        this.goToSleep(20000);
        Status.getInst().append("OK.\n");
        Status.getInst().log("Upgrading firmware for BPME at " + inetAddress.toString() + "...\n");
        if (!this.unlockXport(inetAddress)) {
            Status.getInst().log("Unlock failed...\n");
        }
        if (!this.uploadWebandFirmware(inetAddress)) {
            Status.getInst().log("Upload failed\n");
            return;
        }
        Status.getInst().log("Launch webpage to set new IP settings\n");
        Status.getInst().log("\ton Admin page (pwd = bird)\n");
        this.btnLaunchWebPg_.setEnabled(false);
    }

    private boolean setIPAddressInSetupRecord(InetAddress inetAddress) {
        boolean bl = true;
        try {
            int n;
            this.port_ = 30718;
            if (inetAddress != null) {
                if (this.gtp_ == null) {
                    this.gtp_ = new udpip(inetAddress, this.port_);
                    if (this.gtp_.s == null) {
                        throw new Exception();
                    }
                }
            } else {
                throw new Exception();
            }
            Thread.yield();
            this.cmd_ = (byte)-58;
            this.cmdStr_ = new byte[130];
            this.cmdStr_[3] = this.cmd_;
            this.cmdStr_[1] = 1;
            String string = "bpme.com";
            byte[] byArray = string.getBytes();
            for (n = 0; n < byArray.length; ++n) {
                this.cmdStr_[4 + n] = byArray[n];
            }
            this.cmdStr_[29] = 6;
            string = "bird";
            byArray = string.getBytes();
            for (n = 0; n < byArray.length; ++n) {
                this.cmdStr_[30 + n] = byArray[n];
                this.cmdStr_[80 + n] = byArray[n];
            }
            this.gtp_.send(this.cmdStr_, this.cmdStr_.length);
            this.resp_ = this.gtp_.receive(4, 3000);
            if (this.resp_ == null) {
                bl = false;
            }
            Thread.yield();
            this.cmd_ = (byte)-64;
            this.cmdStr_ = new byte[124];
            this.cmdStr_[3] = this.cmd_;
            this.cmdStr_[1] = 0;
            byte[] byArray2 = inetAddress.getAddress();
            for (int i = 0; i < 4; ++i) {
                this.cmdStr_[4 + i] = byArray2[i];
            }
            this.gtp_.send(this.cmdStr_, this.cmdStr_.length);
            this.resp_ = this.gtp_.receive(4, 3000);
            if (this.resp_ == null) {
                bl = false;
            }
        }
        catch (Exception exception) {
            this.closeUDP();
            System.out.println("Error");
            return false;
        }
        this.closeUDP();
        if (bl) {
            System.out.println("Success");
            return true;
        }
        System.out.println("Failure");
        return false;
    }

    private void handle_setDefaultSettings() {
        this.setWaitCursor();
        this.btnSetupDefault_.setEnabled(false);
        this.btnLaunchWebPg_.setEnabled(false);
        this.workerTh_.addCmd(new GUIWorkerCmd(){

            public void execute() {
                BPMEUpd.this.setExecuting(true);
                BPMEUpd.this.setDefaultSettings();
            }

            public void onFinished() {
                BPMEUpd.this.setExecuting(false);
                BPMEUpd.this.btnSetupDefault_.setEnabled(true);
                BPMEUpd.this.btnLaunchWebPg_.setEnabled(true);
                BPMEUpd.this.restoreCursor();
            }
        });
    }

    private boolean uploadToXPORT(String string, String string2, InetAddress inetAddress) {
        String[] stringArray = new String[]{"tftp", "-i", inetAddress.getHostAddress(), "PUT", string, string2};
        boolean bl = true;
        Runtime runtime = Runtime.getRuntime();
        try {
            Status.getInst().log("Uploading " + string + "...");
            Process process = runtime.exec(stringArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
            int n = bufferedInputStream.read();
            if (n != -1) {
                byte[] byArray = new byte[40];
                byArray[0] = (byte)n;
                int n2 = bufferedInputStream.read(byArray, 1, 39);
                Dbg.getInst().log("Error uploading" + string + ": " + new String(byArray), Dbg.LVL_SYS);
                throw new Exception();
            }
            Status.getInst().append("OK.\n");
        }
        catch (Exception exception) {
            Status.getInst().log("FAILED!\n");
            bl = false;
        }
        return bl;
    }

    private boolean uploadWebContent(InetAddress inetAddress) {
        boolean bl = true;
        try {
            int n;
            String string = SetupProperties.getInst().getProperty("webIn");
            String string2 = SetupProperties.getInst().getProperty("webOutDir");
            Status.getInst().log("Exctracting " + string + "...");
            try {
                WebContent webContent = new WebContent(string);
                webContent.extract(string2);
                SetupProperties.getInst().setProperty("numWebFiles", Integer.toString(webContent.getNumFiles()));
                for (n = 0; n < webContent.getNumFiles(); ++n) {
                    WebContentFile webContentFile = webContent.getFile(n);
                    if (webContentFile == null) continue;
                    SetupProperties.getInst().setWebContentFileName(n, webContentFile.getDestination(), webContentFile.getAbsolutePath());
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                Status.getInst().append("FAILED!\n");
                throw iOException;
            }
            Status.getInst().append("OK.\n");
            int n2 = Integer.parseInt(SetupProperties.getInst().getProperty("numWebFiles"));
            n = 0;
            for (int i = 0; i < n2; ++i) {
                String string3 = SetupProperties.getInst().getWebContentFileDest(i);
                String string4 = SetupProperties.getInst().getWebContentFileName(i);
                if (!this.uploadToXPORT(string4, string3, inetAddress)) {
                    if (n != 0) {
                        bl = false;
                        break;
                    }
                    Status.getInst().log("Trying Again...\n");
                    n = 1;
                    if (!this.unlockXport(inetAddress)) {
                        bl = false;
                        break;
                    }
                    --i;
                }
                this.goToSleep(500);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private int computeCRC(File file) {
        if (file == null) {
            Dbg.getInst().log("inFile is null!", 2);
            return 0;
        }
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            if (l == 0L) {
                Dbg.getInst().log("inFile is EMPTY!", 2);
                throw new Exception();
            }
            int n2 = (int)Math.min(l / 100L, 32768L);
            n2 = Math.max(n2, 1);
            int n3 = (int)(l / (long)n2);
            if (l % (long)n2 != 0L) {
                ++n3;
            }
            Dbg.getInst().log("bytesToRead=" + l + "; " + "blockSize=" + n2 + "; numBlocks=" + n3, 2);
            byte[] byArray = new byte[n2];
            CRC.startRollingCRC();
            int n4 = 0;
            while (!this.isOperationCanceled()) {
                Arrays.fill(byArray, (byte)0);
                n4 = fileInputStream.read(byArray, 0, n2);
                for (int i = 0; i < n4 && !this.isOperationCanceled(); ++i) {
                    CRC.rollingCRC(byArray[i]);
                }
                if (n4 != n2) break;
                Thread.yield();
            }
            n = CRC.finishRollingCRC();
            Dbg.getInst().log("crc16=" + n, 2);
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byArray = null;
        }
        catch (Exception exception) {
            exception.printStackTrace(Dbg.getInst().getPrintStream());
        }
        return n;
    }

    private synchronized boolean unlockXport(InetAddress inetAddress) {
        this.port_ = 10004;
        this.encTcp = new EncryptedTCPIPCommInt(inetAddress, this.port_, 1024);
        try {
            this.encTcp.open();
        }
        catch (Exception exception) {
            Status.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!\n");
            Status.getInst().log("   - Can ignore if a virgin part\n");
            Dbg.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!", Dbg.LVL_SYS);
            Dbg.getInst().log("socket is Null", Dbg.LVL_SYS);
            this.encTcp.close();
            this.encTcp = null;
            return true;
        }
        try {
            byte[] byArray = "unlock all ports".getBytes();
            int n = this.encTcp.send(byArray, byArray.length, 1000);
            if (n != byArray.length) {
                throw new Exception();
            }
            byte[] byArray2 = new byte[8];
            n = this.encTcp.receive(byArray2, byArray2.length, 5000);
            if (n != byArray2.length) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            Status.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!\n");
            Dbg.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!", Dbg.LVL_SYS);
            Dbg.getInst().log("No Response from command", Dbg.LVL_SYS);
            this.encTcp.close();
            this.encTcp = null;
            return false;
        }
        this.encTcp.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeUDP() {
        try {
            if (this.gtp_ != null) {
                this.gtp_.disconnect();
                this.gtp_ = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.gtp_ = null;
        }
    }

    private synchronized boolean isUDPOpen() {
        return this.gtp_ != null;
    }

    private synchronized void goToSleep(int n) {
        try {
            this.wait(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setOperationCanceled(boolean bl) {
        this.isOperationCanceled_ = bl;
    }

    private boolean isOperationCanceled() {
        return this.isOperationCanceled_;
    }

    private void setExecuting(boolean bl) {
        this.isExecuting_ = bl;
    }

    private static String formatCRC16(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() > 4) {
            string = string.substring(4, string.length());
        }
        int n2 = 4 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    BPMEUpd.createAndShowGUI();
                }
            });
        }
        catch (Exception exception) {
            System.out.println("FATAL ERROR - Unable to create GUI!");
            exception.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private static void createAndShowGUI() {
        Dbg.getInst().init(Dbg.LVL_SYS);
        BPMEUpd bPMEUpd = new BPMEUpd("BPME Updater v2.1");
        bPMEUpd.setSize(440, 380);
        bPMEUpd.setResizable(false);
        bPMEUpd.show();
        SetupProperties.getInst().loadAndRestore();
        bPMEUpd.computeCRCValues();
    }

    class StatusKeyAdapter
    extends KeyAdapter {
        StatusKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = 576;
            if (keyEvent.getKeyCode() == 120 && (keyEvent.getModifiersEx() & n) == n) {
                SetupProperties.getInst().loadAndRestore();
                FilesDialog filesDialog = new FilesDialog(null, "Files");
                filesDialog.show();
                try {
                    SetupProperties.getInst().store();
                    BPMEUpd.this.computeCRCValues();
                }
                catch (Exception exception) {
                    Status.getInst().log("Couldn't write to props file.\n");
                }
            } else {
                keyEvent.consume();
            }
        }
    }
}

